﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace AplikacjaBazodanowa
{
    public partial class Form1 : Form
    {
        private bool daneZmienione = false;

        public Form1()
        {
            InitializeComponent();
        }        

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'adresyDataSet.Osoby' table. You can move, or remove it, as needed.
            this.osobyTableAdapter.Fill(this.adresyDataSet.Osoby);
            this.osobyBindingSource.Position = 2;
            daneZmienione = false;
        }

        private void osobyBindingSource_CurrentChanged(object sender, EventArgs e)
        {
            AdresyDataSet.OsobyRow rekord = (osobyBindingSource.Current as DataRowView).Row as AdresyDataSet.OsobyRow;
            Text = rekord.Imię + " " + rekord.Nazwisko;
            try { int numerDomu = rekord.NumerDomu; }
            catch { numericUpDown1.Value = 0; }
            try { int numerMieszkania = rekord.NumerMieszkania; }
            catch { numericUpDown2.Value = 0; }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            daneZmienione = true;
        }

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            if (!daneZmienione) return;
            switch (MessageBox.Show(
                        "Czy zapisać zmiany do bazy danych?", "Adresy", 
                        MessageBoxButtons.YesNoCancel, 
                        MessageBoxIcon.Question, 
                        MessageBoxDefaultButton.Button2))
            {
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
                case DialogResult.Yes:
                    try
                    {
                        this.osobyBindingSource.EndEdit();
                        this.osobyTableAdapter.Update(adresyDataSet.Osoby);
                        MessageBox.Show("Dane zapisane do bazy");
                    }
                    catch (Exception exc)
                    {
                        MessageBox.Show("Zapisanie danych nie powiodło się (" + exc.Message + ")");
                    }
                    break;
                case DialogResult.No:
                    break;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var kolekcjaOsoby = from osoba in adresyDataSet.Osoby
                           orderby osoba.Nazwisko
                           select osoba;
            foreach (AdresyDataSet.OsobyRow osoba in kolekcjaOsoby)
            {
                //miasto
                try{string s = osoba.Miasto;}
                catch (System.Data.StrongTypingException exc){osoba.Miasto = "";}

                //numer domu
                try { int i = osoba.NumerDomu; }
                catch (System.Data.StrongTypingException exc) { osoba.NumerDomu = 0; }

                //numer mieszkania
                try { int i = osoba.NumerMieszkania; }
                catch (System.Data.StrongTypingException exc) { osoba.NumerMieszkania = 0; }
            }

            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XElement("ListaOsob",
                    from osoba in kolekcjaOsoby
                    orderby osoba.Nazwisko
                    select new XElement("Osoba",
                        new XAttribute("Email", osoba.Email),
                        new XElement("Imię", osoba.Imię),
                        new XElement("Nazwisko", osoba.Nazwisko),
                        new XElement("NumerDomu", osoba.NumerDomu),
                        new XElement("NumerMieszkania", osoba.NumerMieszkania),
                        new XElement("Miasto", osoba.Miasto)
                        )
                )
            );

            xml.Save(@"\Temp\Adresy.xml");
        }
    }
}